************************************************************************************************
* Name			: table D1 - impacts of the stimulation and nutritional components of the intervention
*
* Description	: This dofile estimates treatment effects for each arm of the intervention 
************************************************************************************************

********************************************************************************
* SETTINGS 
********************************************************************************
clear 				all 
set more 			off 
set graphics 		off 
version 			15          /*Use Stata 15*/ 
set seed			16072015   	/* This is the seed number that was used to create the bootstrapped samples for estimation of the model in the paper */ 

* Options for data to create 
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 			/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

* Globals of directories, variable groups and others 
run "$dir_statacode\globals.do" 

* Dataset with standardized measures 
use "$dir_data\measures.dta", clear 


******************************************************************************* 
* CLEANING 
******************************************************************************* 

gen stim=0 if group0==1 | group0==4 
replace stim=1 if group0==2 | group0==3

gen both = 0 if group0==1 | group0==3 | group0==4 
replace both = 1 if group0==2 

gen nutri = 0 if group0==2 | group0==4 
replace nutri = 1 if group0==1 | group0==3 


******************************************************************************* 
* ESTIMATION - PANEL A (Child's cognitive skills at follow up) 
******************************************************************************* 
local bayley "b_tot_cog b_tot_lr b_tot_le b_tot_mf"
foreach y of local bayley{
local append append 
if "`y'"=="b_tot_cog" local append replace 
	cap drop V*
	reg `y'1_st stim nutri both `y'0_st $covs_eva , cl(cod_dane)
	outreg2 using "$dir_output/TableD1.xls", `append' $outregopt ctitle("`y'")  
} 

local macarthur "mac_words mac_phrases"
foreach y of local macarthur{
	cap drop V*
	reg `y'1_st stim nutri both mac_words0_st $covs_ent , cl(cod_dane)
	outreg2 using "$dir_output/TableD1.xls", append $outregopt ctitle("`y'")  
} 

******************************************************************************* 
* ESTIMATION - PANEL B (Child's socio-emotional skills at follow up) 
******************************************************************************* 
local bates "bates_unsociable bates_difficult bates_unstoppable" 
foreach y of local bates{
	cap drop V*
	reg `y'1_st stim nutri both `y'0_st $covs_ent, cl(cod_dane)
	outreg2 using "$dir_output/TableD1.xls", append $outregopt ctitle("`y'")  
} 

local roth "roth_inhibit roth_attention" 
foreach y of local roth{
	cap drop V*
	reg `y'1_st stim nutri both bates_difficult0_st $covs_ent , cl(cod_dane)
	outreg2 using "$dir_output/TableD1.xls", append $outregopt ctitle("`y'")  
} 

******************************************************************************* 
* ESTIMATION - PANEL C (Material investments)  
******************************************************************************* 
local fcimat "fci_play_mat_type  Npaintbooks Nthingsmove Ntoysshape Ntoysbought"
foreach y of local fcimat{
	cap drop V*
	reg `y'1_st stim nutri both fci_play_mat_type0_st $covs_ent , cl(cod_dane)
	outreg2 using "$dir_output/TableD1.xls", append $outregopt ctitle("`y'")  
} 

******************************************************************************* 
* ESTIMATION - PANEL D (Time investments)  
******************************************************************************* 
local fcitime "fci_play_act home_stories home_read home_toys home_name"
foreach y of local fcitime{
	cap drop V*
	reg `y'1_st stim nutri both fci_play_act0_st $covs_ent , cl(cod_dane)
	outreg2 using "$dir_output/TableD1.xls", append $outregopt ctitle("`y'")  
} 

